--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNtreeParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCtreePath    = ""
  local LOCundoState   = on -- used only in spinner undo functions
  local LOCspinStartValue     -- used only in spinner undo functions
  local LOCtreesArray = #()
  local LOCiniArraysUpdateRequired = true -- used to check whether DYNobjectPlacer.DYNFUNmakeINIobjFileArrays has been called since this panel was last opened
  local LOCresourceKitMode = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspTreeFilter       FUNobj = (classof FUNobj.baseObject == VSP_Tree)

  fn DYNFUNtreeParams FUNobj =
  (
    FUNobj.baseObject.height           = FUNobj.baseObject.height -- Workaround for object to display any non-authorised parameter changes

    DYNtreeParams.LOCobj               = FUNobj
    DYNtreeParams.SPDYNfaces.value     = FUNobj.baseObject.nFaces
    DYNtreeParams.SPDYNwidth.value     = FUNobj.baseObject.width
    DYNtreeParams.SPDYNheight.value    = FUNobj.baseObject.height

    --- Get current Tree Type (Bitmap)
    DYNtreeParams.LOCtreesArray = DYNFUNgetMatChannelNames FUNobj.material false false DYNINImatIDlimit
    if DYNtreeParams.LOCtreesArray.count > 0 then -- means that multi/sub object material WAS found
    (
      local LOCmatID = if FUNobj.baseObject.matID > DYNtreeParams.LOCtreesArray.count then DYNtreeParams.LOCtreesArray.count else FUNobj.baseObject.matID
      FUNobj.baseObject.matID = LOCmatID
      if DYNtreeParams.LOCtreesArray.count >= FUNobj.baseObject.matID then
      (
        DYNtreeParams.LBDYNobjName.text  = DYNtreeParams.LOCtreesArray[FUNobj.baseObject.matID]
      )
      else
      (
        DYNtreeParams.LBDYNobjName.text  = ""
      )

      --- If Tree Object INI File Definition does not exist, disable RESET and DROPDOWN list (This can occur when the wrong country kit is currently loaded)
      local LOCswitch = doesFileExist (DYNtreeParams.LOCtreePath + DYNtreeParams.LBDYNobjName.text + ".ini")
    )

    if FUNobj.material != undefined then
    (
      DYNtreeParams.BMDYNbitmap.bitmap = DYNFUNrenderMatMap DYNtreeParams.BMDYNbitmap.width DYNtreeParams.BMDYNbitmap.height FUNobj.material FUNobj.baseObject.matID
    )

    --- Create A Temporary Array Of Tree Object INI Files From Current DVSP Country Kit Folders
    local LOCtreeArray = DYNFUNgetfiles DYNtreeParams.LOCtreePath 1 "*.ini" -- Purely temp array for following line. Can't use ConfigGetAllBases here, because arrays might not yet be populated
    DYNtreeParams.BUDYNotherTypes.enabled = if classOf FUNobj.material == Multimaterial and LOCtreeArray.count > 0 then true else false

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNtreeParams FUNobj
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) pos:[4,7]   height:193
  bitmap BMDYNbitmap align:#center width:(DYNiniExplorerWidth - 36) height:120 pos:[11,26]
  label LBDYNobjName align:#left pos:[11,155] width:(DYNiniExplorerWidth - 36)
  button BUDYNotherTypes align:#center width:(DYNiniExplorerWidth - 36) pos:[11,173]

  groupbox GBDYNgroup02 width:(DYNiniExplorerWidth - 21) pos:[4,205]   height:83
  label LBDYNheight width:105 pos:[11,224]
  label LBDYNwidth  width:105 pos:[11,245]
  label LBDYNfaces  width:105 pos:[11,266]
  spinner  SPDYNheight "" fieldwidth:60 type:#worldunits range:[0,10000,11] pos:[(DYNiniExplorerWidth - 96),224]
  spinner  SPDYNwidth  "" fieldwidth:60 type:#worldunits range:[0,10000,6]  pos:[(DYNiniExplorerWidth - 96),245]
  spinner  SPDYNfaces  "" fieldwidth:60 type:#integer    range:[1,8,1]      pos:[(DYNiniExplorerWidth - 96),266]

  groupbox GBDYNgroup03 width:(DYNiniExplorerWidth - 21) pos:[4,293]   height:72
  checkbutton CBDYNlinked width:(DYNiniExplorerWidth - 36) highlightColor:DYNINIhighlightColor   pos:[11,312]
  pickbutton PKDYNlink    width:(DYNiniExplorerWidth - 36) highlightColor:DYNINIhighlightColor filter:DYNFUNvspTreeFilter pos:[11,338]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNtreeParams open do
  (
    DYNtreeParams.title  = DYNuiRolloutNames[5]
    LBDYNheight.text     = DYNuiResourcesLabels[93]
    LBDYNwidth.text      = DYNuiResourcesLabels[94]
    LBDYNfaces.text      = DYNuiResourcesLabels[95]
    GBDYNgroup01.text    = DYNuiResourcesGroups[28]
    GBDYNgroup02.text    = DYNuiResourcesGroups[29]
    GBDYNgroup03.text    = DYNuiResourcesGroups[1]
    LOCtreePath          = DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees + "\\"
    BUDYNotherTypes.text = DYNuiResourcesButtons[44]
    PKDYNlink.text       = DYNuiResourcesButtons[24]
    LOCiniArraysUpdateRequired = true -- used to check whether DYNobjectPlacer.DYNFUNmakeINIobjFileArrays has been called since this panel was last opened
  )

  on DYNtreeParams close do
  (
    LOCobj = undefined
    LOCtreesArray = #()
  )

  --- Faces Spinner
  on SPDYNfaces changed arg do (with undo label:(DYNuiResourcesUndoLabels[9]) LOCundoState LOCobj.baseObject.nFaces = arg)
  on SPDYNfaces buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNfaces.value)  -- store current spinner value
  on SPDYNfaces buttonUp    do
  (
    if LOCspinStartValue != SPDYNfaces.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.nFaces = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[9]) on LOCobj.baseObject.nFaces = SPDYNfaces.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )


  --- Width Spinner Controls
  on SPDYNwidth changed arg do (with undo label:(DYNuiResourcesUndoLabels[9]) LOCundoState LOCobj.baseObject.width = arg)
  on SPDYNwidth buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNwidth.value)  -- store current spinner value
  on SPDYNwidth buttonUp    do
  (
    if LOCspinStartValue != SPDYNwidth.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.width = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[9]) on LOCobj.baseObject.width = SPDYNwidth.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )


  --- Height Spinner Controls
  on SPDYNheight changed arg do (with undo label:(DYNuiResourcesUndoLabels[9]) LOCundoState LOCobj.baseObject.height = arg)
  on SPDYNheight buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheight.value)  -- store current spinner value
  on SPDYNheight buttonUp    do
  (
    if LOCspinStartValue != SPDYNheight.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.height = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[9]) on LOCobj.baseObject.height = SPDYNheight.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  on BUDYNotherTypes pressed do
  (
    --- Update Main Object INI File AX Internal Arrays
    if LOCiniArraysUpdateRequired then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays() -- Update ax Object INI file internal arrays
      LOCiniArraysUpdateRequired = false
    )

    --- Display Tree Selection List
    local LOCnewFile = DYNFUNdisplayListBoxWithMapPreview DYNtreeParams DYNuiResourcesTitlebars[20] "" 3 1 "" "" ""

    if LOCnewFile != "" then -- cannot allow selection of first item which is always indicates that no file has been selected
    (
      if (findItem LOCtreesArray LOCnewFile) == 0 then
      (
        --- Update Current Tree Object With New Tree INI Definition
        local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 3 LOCresourceKitMode
        local LOCmatID = DYNFUNaddTreeMatChannel LOCobj.material LOCsizeArray false
        LOCobj.baseObject.matID = LOCmatID
        local LOCvariation = DYNINItreeVariation / 100.0  -- Is sourced from main VSP INI File
        SPDYNwidth.value   = LOCobj.baseObject.width  = random (LOCsizeArray[3] * (1.0 - LOCvariation)) (LOCsizeArray[3] * (1.0 + LOCvariation))
        SPDYNheight.value  = LOCobj.baseObject.height = random (LOCsizeArray[4] * (1.0 - LOCvariation)) (LOCsizeArray[4] * (1.0 + LOCvariation))
        setAppData LOCobj 423 (LOCobj.baseObject.matID as string)
        setAppData LOCobj 424 (LOCtreePath + LOCnewFile + ".ini")
        DYNFUNtreeParams LOCobj
        DYNproperties.DYNFUNupdPropertiesPanel()
      )
      else
      (
        undo off
        (
          local LOCnewMatID = findItem LOCtreesArray LOCnewFile -- can't be zero, because check already made to enter this loop
          if LOCobj.baseObject.matID != LOCnewMatID then
          (
            LOCobj.baseObject.matID  = LOCnewMatID
            local LOCvariation = DYNINItreeVariation / 100.0  -- Is sourced from main VSP INI File
            local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 3 LOCresourceKitMode
            SPDYNwidth.value   = LOCobj.baseObject.width  = random (LOCsizeArray[3] * (1.0 - LOCvariation)) (LOCsizeArray[3] * (1.0 + LOCvariation))
            SPDYNheight.value  = LOCobj.baseObject.height = random (LOCsizeArray[4] * (1.0 - LOCvariation)) (LOCsizeArray[4] * (1.0 + LOCvariation))
            setAppData LOCobj 423 (LOCobj.baseObject.matID as string)
            setAppData LOCobj 424 (LOCtreePath + LOCnewFile + ".ini")
            DYNFUNtreeParams LOCobj
            DYNproperties.DYNFUNupdPropertiesPanel()
          )
        )
      )
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNtreeParams LOCobj 3 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNtreeParams LOCobj 2 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )
)
